import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define constants for grid dimensions
rows, cols = 6, 4
cell_size = 1

# Define piece colors
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow'
}

# Create a figure and axis
fig, ax = plt.subplots(figsize=(cols * cell_size, rows * cell_size))

# Draw the grid
for row in range(rows):
    for col in range(cols):
        ax.add_patch(patches.Rectangle((col, row), cell_size, cell_size,
                                       edgecolor='black', facecolor='none'))

# Function to draw a piece
def draw_piece(ax, positions, piece_name, color):
    for pos in positions:
        row, col = pos
        ax.add_patch(patches.Rectangle((col, row), cell_size, cell_size,
                                       edgecolor='black', facecolor=color, linewidth=3))
        ax.text(col + 0.5, row + 0.75, piece_name, va='center', ha='center', fontsize=8, color='white')
        ax.text(col + 0.5, row + 0.25, 'occupied', va='center', ha='center', fontsize=6, color='white')

# Draw pieces
draw_piece(ax, [(3, 0), (3, 1), (2, 0)], 'rightl0', colors['rightl0'])
draw_piece(ax, [(1, 0), (1, 1), (0, 0)], 'rightl1', colors['rightl1'])
draw_piece(ax, [(1, 2)], 'square0', colors['square0'])
draw_piece(ax, [(2, 2)], 'square1', colors['square1'])

# Draw clear grid cells
clear_positions = [(5, 0), (5, 1), (5, 2), (5, 3),
                   (4, 0), (4, 1), (4, 2), (4, 3),
                   (3, 2), (3, 3), (2, 1), (2, 3),
                   (1, 3), (0, 1), (0, 2), (0, 3)]
for pos in clear_positions:
    row, col = pos
    ax.text(col + 0.5, row + 0.5, f'f{row}-{col}f\nclear', va='center', ha='center', fontsize=6, color='black')

# Create a legend
legend_patches = [patches.Patch(color=color, label=f'{name} (occupied)') for name, color in colors.items()]
legend_patches.append(patches.Patch(color='none', label='clear'))
ax.legend(handles=legend_patches, loc='upper right')

# Set limits and invert y-axis
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.invert_yaxis()

# Remove axes
ax.axis('off')

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_12.png', bbox_inches='tight')
plt.close()
# VERIFICATION FAILED:
# Legend overlaps with grid objects, making text unclear.
